/*
 * Lachesis, an IRCRPG combat engine - Log management
 * Copyright 2003-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "root.h"
#include "logcmd.h"
#include "../log.h"
#include "../auth.h"
#include "../utils.h"
#include "../types.h"
#include "../alloc.h"
#include "../lachesis.h"
#include "../config.h"

static char* id="@(#) $Id: logcmd.cc,v 1.1.1.1 2004/01/16 07:28:15 lachesis Exp $";

extern TF log_active;
extern FILE *log_file;
extern CmdOpts options;

#ifndef RPGSERV
extern Cmd_PMod cmd_modules;

void Cmd_logcmd_Init()
{
  Cmd_Alloc(&Cmd_Log_Root, "log", CMD_AUTH_MASTER);
}
#endif

void Cmd_Log_Root(void *ticket, int auth, const char *str)
{
  if (str==NULL||!*str) {
    if (options.logfile!=NULL&&*options.logfile) {
      if (log_file==NULL) {
	Auth_CmdResult(ticket, auth,
		       Util_Format("Existing or invalid logfile: %s",
				   options.logfile, NULL, NULL));
	return ;
      }
      if (log_active)
	Auth_CmdResult(ticket, auth, 
		       Util_Format("Logging to file %s is \2active\2.",
				   options.logfile, NULL, NULL));
      else
	Auth_CmdResult(ticket, auth,
		       Util_Format("Logging to file %s is inactive.",
				   options.logfile, NULL, NULL));
    } else
      Auth_CmdResult(ticket, auth, "No logfile.");
    return ;
  }
  const char *cmd, *data;
  data = str;
  cmd = Util_Separate(&data, 32);
  if (!cmd) {
    cmd = data;
    data = NULL;
  }
  if (strcasecmp(cmd, "FILE")==0) {
    if (data==NULL||!*data)
      Auth_CmdResult(ticket, auth, "Filename required.");
    else {
      Log_Cleanup();
      if (options.logfile!=NULL)
	free(options.logfile);
      options.logfile = strdup(data);
      Log_Init();
      if (log_file==NULL)
	Auth_CmdResult(ticket, auth, "Invalid or existing filename.");
      else
	Auth_CmdResult(ticket, auth, "Log opened.");
    }
    return ;
  }
  if (strcasecmp(cmd, "CLOSE")==0) {
    Log_Cleanup();
    if (options.logfile!=NULL) {
      free(options.logfile);
      options.logfile = NULL;
    }
    Auth_CmdResult(ticket, auth, "Log closed.");
    return ;
  }
  if (strcasecmp(cmd, "ON")==0) {
    if (log_file==NULL)
      Auth_CmdResult(ticket, auth, "No logfile open.");
    else {
      log_active=TRUE;
      Auth_CmdResult(ticket, auth, "Logging \2active\2.");
    }
    return ;
  }
  if (strcasecmp(cmd, "OFF")==0) {
    if (log_file==NULL)
      Auth_CmdResult(ticket, auth, "No logfile open.");
    else {
      log_active=FALSE;
      Auth_CmdResult(ticket, auth, "Logging inactive.");
    }
    return ;
  }
  Auth_CmdResult(ticket, auth, Util_Format("Unrecognized command: %s", cmd,
					   NULL, NULL)
		 );
}
