/*
 * Various utility functions
 */

#include "types.h"

#ifndef _UTILS_H_
#define _UTILS_H_

#include <stdio.h>
#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

long Util_Getline(char **, size_t *, FILE *);
const char * Util_Separate(const char **, char);
void Util_SepTo(char *, int, const char **, char);
void Util_Explode(const char *, char, const char **, int);
int Util_Count(const char *, char);
void Util_Copy(char *, const char *, unsigned int size);
void Util_Cat(char *, const char *, unsigned int size);
void Util_Strip(char *, unsigned int size, TF flag);
void Util_Eputs(const char *);
void Util_Eprintf(const char *, ...);
char * Util_FormatA(const char *, ...);
const char * Util_Format(const char *, ...);
const char * Util_FormatD(const char *, const char *, const char *,
			  const char *);
const char * Util_CTCPFmt(const char *, const char *);
const char * Util_CTCPFmtD(const char *, const char *);

#ifdef __cplusplus
}
#endif

#endif
