/*
 * Lachesis, an IRCRPG combat engine - Root command handler.
 * Copyright 2002 M. Dennis
 *
 * This program is free software; please see the file COPYING for details.
 */

#include <string.h>
#include <stdio.h>
#include "root.h"
#include "../utils.h"
#include "../auth.h"
#include "modinc.h"  
// Generated by mkmoddep for module initialization prototyping.

Cmd_PMod cmd_modules;

void Cmd_Init()
{
#ifdef DEBUG
  fputs("DEBUG - Cmd_Init called\n", stderr);
#endif
  cmd_modules = NULL;
#include "modinit.lst"  
  // Generated by mkmoddep for module initialization.
}

void Cmd_Alloc(void (*f)(void *, int, const char *), const char *cmd, int auth)
{
  Cmd_PMod temp;
  if (cmd_modules) {
    for (temp=cmd_modules;temp->next;temp=temp->next) ;
    temp->next = new Cmd_TMod;
    temp = temp->next;
  } else
    temp = cmd_modules = new Cmd_TMod;
  temp->f = f;
  Util_Copy(temp->cmd, cmd, ALLOC_CMD);
  temp->auth = auth;
  temp->next=NULL;
}

void Cmd_Cleanup()
{
#ifdef DEBUG
  fputs("DEBUG - Cmd_Cleanup called\n", stderr);
#endif
  Cmd_PMod temp;
  while (cmd_modules) {
    temp=cmd_modules;
    cmd_modules=cmd_modules->next;
    delete [] temp;
  }
}

void Cmd_Root(void *ticket, int auth, const char *str)
{
  const char *data, *cmd;
  Cmd_PMod temp;

#ifdef DEBUG
  fputs("DEBUG - Cmd_Root called\n", stderr);
#endif
  data = str;
  cmd = Util_Separate(&data, 32);
  if (cmd==NULL) {
    cmd = data;
    data = NULL;
  }
  for (temp=cmd_modules;temp;temp=temp->next)
    if (strcasecmp(temp->cmd, cmd)==0) {
      if (auth<temp->auth)
	Auth_CmdResult(ticket, auth, Util_FormatD("You are not authorized to use %s commands.", cmd, NULL, NULL));
      else
	(*(temp->f))(ticket, auth, data);
      return ;
    }
  Auth_CmdResult(ticket, auth, 
		 Util_FormatD("I do not recognize %s as a command.", cmd,
			      NULL, NULL)
		 );
}
